/*
Copyright 2008-2011 Broadcom Corporation

This program isthe proprietary software of Broadcom Corporation and/or its
licensors, and may only be used, duplicated, modifiedor distributed pursuant to
the terms and conditions of a separate, written license agreement executed
between you and Broadcom (an "Authorized License"). Except as set forth in an
Authorized License, Broadcom grants no license (express or implied), right to
use, or waiver of any kind with respect to the Software, and Broadcom expressly
reserves all rights in and to the Software and all intellectual property rights
therein. IF YOU HAVE NO AUTHORIZED LICENSE, THEN YOU HAVE NO RIGHT TO USE THIS
SOFTWARE IN ANY WAY, AND SHOULD IMMEDIATELY NOTIFY BROADCOM AND DISCONTINUE ALL
USE OF THE SOFTWARE.

Except as expressly set forth in the Authorized License,

1. This program, including its structure, sequence and organization, constitutes
   the valuable trade secrets of Broadcom, and you shall use all reasonable
   efforts to protect the confidentiality thereof, and to use this information
   only in connection with your use of Broadcom integrated circuit products.

2.TO THE MAXIMUM EXTENT PERMITTED BY LAW, THE SOFTWAREIS PROVIDED "AS IS" AND
   WITH ALL FAULTS AND BROADCOM MAKES NO PROMISES, REPRESENTATIONS OR
   WARRANTIES, EITHER EXPRESS, IMPLIED, STATUTORY, OR OTHERWISE, WITH RESPECT TO
   THE SOFTWARE.  BROADCOM SPECIFICALLY DISCLAIMSANY AND ALL IMPLIED WARRANTIES
   OF TITLE, MERCHANTABILITY, NONINFRINGEMENT, FITNESS FOR A PARTICULAR PURPOSE,
   LACK OF VIRUSES, ACCURACY OR COMPLETENESS, QUIET ENJOYMENT, QUIET POSSESSION
   OR CORRESPONDENCE TO DESCRIPTION. YOU ASSUME THE ENTIRE RISK ARISING OUT OF
   USE OR PERFORMANCE OF THE SOFTWARE.

3.TO THE MAXIMUM EXTENT PERMITTED BY LAW, IN NO EVENT SHALL BROADCOM OR ITS
   LICENSORS BE LIABLE FOR(i) CONSEQUENTIAL, INCIDENTAL, SPECIAL, INDIRECT, OR
   EXEMPLARY DAMAGES WHATSOEVER ARISING OUT OF OR IN ANY WAY RELATING TO YOUR
   USE OF OR INABILITY TO USE THE SOFTWARE EVEN IF BROADCOM HAS BEEN ADVISED OF
   THE POSSIBILITY OF SUCH DAMAGES; OR (ii) ANY AMOUNT IN EXCESS OF THE AMOUNT
   ACTUALLY PAID FOR THE SOFTWARE ITSELF OR U.S. $1, WHICHEVER IS GREATER. THESE
   LIMITATIONS SHALL APPLY NOTWITHSTANDING ANY FAILURE OF ESSENTIAL PURPOSE OF
   ANY LIMITED REMEDY.
*/
/** \file netlayer.h
 *
 * \brief This are the definitions for the network layer
 *
 **************************************************/

#ifndef NETLAYER_H_
#define NETLAYER_H_

/***************************************************
*                 Include section
***************************************************/
#include "base_types.h"
#include "framework.h"

/***************************************************
 *                 Public Defines Section
 ***************************************************/

/***************************************************
 *                 Public Constants Section
 ***************************************************/

 /***************************************************
 *                 Public Typedefs Section
 ***************************************************/

 /***************************************************
 *         Public Function Prototypes Section
 ***************************************************/

/**
 * \brief               Init network layer
 */
TBool _netlayer_ini(char* ifname);

/**
 * \brief               Close network layer
 */
void _netlayer_close();

/**
 * \brief            Network layer transmission function
 *
 * \param p_layer    (in) protocol layer
 * \param p_pkt      (in) protocol packet to transmit
 */
void netlayer_Transmit(tS_layer* p_layer, tS_pkt* p_pkt);

/**
 * \brief            Network layer reception function
 *
 * \param p_layer    (in) protocol layer
 * \param p_pkt      (in) protocol packet received
 */
void netlayer_Handle_Receive(tS_layer* p_layer, tS_pkt* p_pkt);


/**
 * \brief               Set network layer to comm with a STA
 *
 * \param STA           (in) MAC address for the STA
 */
void _netlayer_open(TU8* STA);

/**
 * \brief               Obtain HLE address
 *
 * \param HLE           (out) MAC address for the HLE
 */
void _netlayer_get_ifMacAddr(TU8* HLE);



#endif

